# Pixel Art Creator

A feature-rich desktop pixel art application built with Electron.

## Features

### Core Features
- **Custom Color Picker**: Full color selection with hex input
- **PNG Export**: Export your artwork as PNG files
- **Drawing Tools**: Multiple tools for creative freedom
- **Desktop Application**: Cross-platform desktop app (macOS, Windows, Linux)

### Drawing Tools
- **Pencil**: Draw individual pixels
- **Eraser**: Erase pixels (sets to white)
- **Fill Bucket**: Flood fill areas with color
- **Eyedropper**: Pick colors from the canvas
- **Line**: Draw straight lines
- **Rectangle**: Draw filled rectangles
- **Circle**: Draw filled circles/ellipses

### Advanced Features
- **Dual Color System**: Primary and secondary colors (left/right click)
- **Color Palette**: Save and reuse your favorite colors
- **Undo/Redo**: Full history with 50 steps (Ctrl+Z / Ctrl+Y)
- **Grid Toggle**: Show/hide pixel grid
- **Zoom Controls**: Zoom from 25% to 400%
- **Canvas Resize**: Adjustable canvas size (8x8 to 128x128)
- **Live Preview**: See your artwork at actual pixel size
- **Keyboard Shortcuts**: Fast workflow with hotkeys

## Installation

### Prerequisites
- Node.js (v16 or higher)
- npm (comes with Node.js)

### Setup

1. Install dependencies:
```bash
npm install
```

2. Run the application:
```bash
npm start
```

### Building for Distribution

To package the app for your platform:

```bash
npm run package
```

This will create distributable builds in the `dist` folder.

## Usage

### Mouse Controls
- **Left Click**: Draw with primary color
- **Right Click**: Draw with secondary color
- **Click on color swatches**: Set colors from palette

### Keyboard Shortcuts

#### Tools
- `P` - Pencil
- `E` - Eraser
- `F` - Fill Bucket
- `I` - Eyedropper
- `L` - Line
- `R` - Rectangle
- `C` - Circle

#### Actions
- `Ctrl+Z` - Undo
- `Ctrl+Y` - Redo
- `X` - Swap primary/secondary colors

### Workflow Tips

1. **Setting up colors**:
   - Use the color picker or hex input to choose colors
   - Add frequently used colors to the palette
   - Right-click palette colors to set as secondary color

2. **Drawing shapes**:
   - Select shape tool (Line, Rectangle, Circle)
   - Click and drag to define the shape
   - Release to draw

3. **Using the fill bucket**:
   - Select the Fill tool
   - Click on any pixel to fill connected areas of the same color

4. **Canvas management**:
   - Use the zoom controls for detailed work
   - Toggle grid off for a cleaner view
   - Check the Preview panel to see actual size

5. **Exporting**:
   - Click "Export PNG" to save your artwork
   - The exported image will be at the exact pixel dimensions (e.g., 32x32)

## Technical Details

### Built With
- **Electron**: Desktop application framework
- **HTML5 Canvas**: Rendering and drawing
- **Vanilla JavaScript**: No framework dependencies
- **CSS3**: Modern UI styling

### Canvas System
- Main canvas: Drawing surface with pixel grid
- Overlay canvas: Grid and shape previews
- Preview canvas: Real-time actual-size preview

### Performance
- Optimized flood fill algorithm
- Efficient undo/redo with canvas snapshots
- Hardware-accelerated rendering

## Project Structure

```
pixel-art-creator/
├── main.js           # Electron main process
├── index.html        # Application UI
├── styles.css        # Application styling
├── app.js            # Application logic
├── package.json      # Dependencies and scripts
└── README.md         # This file
```

## License

MIT License - feel free to use and modify as needed!

## Future Enhancement Ideas

- Layer support
- Animation frames
- Custom export sizes (upscaling)
- Import existing images
- More shape tools (filled/outlined options)
- Gradient fills
- Dithering patterns
- Sprite sheet export
- Custom brush sizes
- Symmetry mode
- Color palette import/export

Enjoy creating pixel art!
